/* - MCMotorEncoderPositionUpdateListener -
 * Display the data from a motor encoder position update event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.event.EncoderPositionUpdateListener;
import com.phidgets.event.EncoderPositionUpdateEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MCEncoderPositionUpdateListener implements EncoderPositionUpdateListener {

    private JComboBox motorCmb;
    private JTextField encoderArray[];

    public MCEncoderPositionUpdateListener(JTextField encoderArray[], JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.encoderArray = encoderArray;
    }

    public void encoderPositionUpdated(EncoderPositionUpdateEvent encoderPositionEvent) {
        encoderArray[encoderPositionEvent.getIndex()].setText(Integer.toString(encoderPositionEvent.getValue()));
    }
}
